/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.xplat.IXplatAbstractions;
import vazkii.patchouli.api.IVariable;

public class PatchouliUtils {
    private static boolean crafttweakerInfoNote = false;

    public static <T extends Recipe<C>, C extends Container> T getRecipe(RecipeType<T> type, ResourceLocation id) {
        Map map = ModRecipeTypes.getRecipes((Level)Minecraft.m_91087_().f_91073_, type);
        Recipe r = map.get(id);
        if (r != null) {
            return (T)r;
        }
        r = map.get(new ResourceLocation("crafttweaker", id.m_135815_()));
        if (r != null) {
            return (T)r;
        }
        r = map.get(new ResourceLocation("crafttweaker", "autogenerated/" + id.m_135827_() + "." + id.m_135815_()));
        if (r != null) {
            return (T)r;
        }
        BotaniaAPI.LOGGER.warn("Template references nonexistent recipe {} of type {}", (Object)id, type);
        if (!crafttweakerInfoNote) {
            crafttweakerInfoNote = true;
            if (IXplatAbstractions.INSTANCE.isModLoaded("crafttweaker")) {
                BotaniaAPI.LOGGER.info("To add a recipe that replaces a builtin recipe with CT, \nadd one with the same type, named the same as the path of the missing recipe.\neg. for recipe {}, add a recipe named \"{}\".", (Object)id, (Object)id.m_135815_());
            }
        }
        return null;
    }

    public static <T extends Recipe<C>, C extends Container> List<T> getRecipeGroup(RecipeType<T> type, String group) {
        Map map = ModRecipeTypes.getRecipes((Level)Minecraft.m_91087_().f_91073_, type);
        ArrayList list = new ArrayList();
        for (Recipe value : map.values()) {
            if (!group.equals(value.m_6076_())) continue;
            list.add(value);
        }
        if (list.isEmpty()) {
            BotaniaAPI.LOGGER.warn("Template references empty group {} of recipe type {}", (Object)group, type);
        }
        return list;
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients, int longestIngredientSize) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingredients.get(0).m_43908_()).map(IVariable::from).collect(Collectors.toList()));
        }
        ItemStack[] empty = new ItemStack[]{ItemStack.f_41583_};
        ArrayList<ItemStack[]> stacks = new ArrayList<ItemStack[]>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.m_43947_()) {
                stacks.add(ingredient.m_43908_());
                continue;
            }
            stacks.add(empty);
        }
        ArrayList<IVariable> list = new ArrayList<IVariable>(stacks.size() * longestIngredientSize);
        for (int i = 0; i < longestIngredientSize; ++i) {
            for (ItemStack[] stack : stacks) {
                list.add(IVariable.from((Object)stack[i % stack.length]));
            }
        }
        return IVariable.wrapList(list);
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients) {
        return PatchouliUtils.interweaveIngredients(ingredients, ingredients.stream().mapToInt(ingr -> ingr.m_43908_().length).max().orElse(1));
    }
}

